/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.NoSuchElementException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

class timerWindow {
    private JFrame tWindow;
    private final JFileChooser fc = new JFileChooser();
    private static final int major = 2;
    private static final int minor = 2;
    private static final int bugfix = 0;
    private static final String date = "24/07/07";
    private TimerFileFilter filter = new TimerFileFilter();
    private JMenuBar menu;
    private JMenu fileMenu;
    private JMenuItem fileBlank;
    private JMenuItem fileLoad;
    private JMenuItem fileSave;
    private JMenuItem fileExit;
    private JMenu toolsMenu;
    private JMenuItem toolsStop;
    private JMenuItem toolsMulti;
    private JMenuItem toolsStartAll;
    private JMenuItem toolsStopAll;
    private JMenuItem toolsOptions;
    private JMenu helpMenu;
    private JMenuItem helpUpdate;
    private JMenuItem helpAbout;
    private JPanel soundPanel;
    private JPanel timerPanel;
    private JButton stopSound;
    private JButton multi;
    private JButton egg;
    private timer t1 = new timer(this, 1);
    private timer t2 = new timer(this, 2);
    private timer t3 = new timer(this, 3);
    private timer t4 = new timer(this, 4);
    private timer t5 = new timer(this, 5);
    private timer t6 = new timer(this, 6);
    private timer t7 = new timer(this, 7);
    private timer t8 = new timer(this, 8);
    private timer t9 = new timer(this, 9);
    private int running = 0;
    private AudioClip clip;
    private URL codeBase;
    private final String optionsFile = "options.dat";
    private final String ralert = "alert";
    private final int rsnoozehour = 0;
    private final int rsnoozemin = 5;
    private final int rsnoozesec = 0;
    private final int rtimetype = 0;
    private String alert = "alert";
    private int snoozehour = 0;
    private int snoozemin = 5;
    private int snoozesec = 0;
    private int timetype = 0;
    private JFrame optionsPanel;
    private JPanel optPanel1 = new JPanel();
    private JPanel optPanel2 = new JPanel();
    private JPanel optPanel3 = new JPanel();
    private JPanel optPanel4 = new JPanel();
    private final JLabel optAlarmLabel = new JLabel("Alarm Sound:");
    private final JLabel optSnoozeLabel = new JLabel("Snooze Time:");
    private final JLabel optTypeLabel = new JLabel("Time Type:");
    private JButton resetAlarm = new JButton("Reset");
    private JButton resetSnooze = new JButton("Reset");
    private JButton resetType = new JButton("Reset");
    private JButton resetAll = new JButton("Reset All");
    private JTextField optAlarm = new JTextField(10);
    private JTextField optSnzeHr = new JTextField(2);
    private JTextField optSnzeMin = new JTextField(2);
    private JTextField optSnzeSec = new JTextField(2);
    private JComboBox optTimetype = new JComboBox();
    private JButton optOK = new JButton("OK");
    private JButton optCancel = new JButton("Cancel");

    public timerWindow() {
        this.tWindow = new JFrame("Jarada's Time Keepers V2");
        this.menu = new JMenuBar();
        this.soundPanel = new JPanel();
        this.timerPanel = new JPanel();
        this.filter.addExtension("jtk");
        this.filter.setDescription("Jarada's Time Keeper");
        this.fc.setFileFilter(this.filter);
        this.sortMenus();
        this.menu.add(this.fileMenu);
        this.menu.add(this.toolsMenu);
        this.menu.add(this.helpMenu);
        this.stopSound = new JButton("Stop Alarm");
        this.stopSound.addActionListener(new stopAlarm());
        this.multi = new JButton("Multi S/S");
        this.multi.addActionListener(new multiListener());
        this.egg = new JButton("?");
        this.egg.addActionListener(new eggListener());
        this.soundPanel.add(this.stopSound);
        this.soundPanel.add(this.multi);
        this.soundPanel.add(this.egg);
        this.timerPanel.setLayout(new GridLayout(3, 3));
        this.setTimerPanel();
        this.optTimetype.addItem("AM/PM");
        this.optTimetype.addItem("24Hr");
        this.optOK.addActionListener(new optionsPanelRespond());
        this.optCancel.addActionListener(new optionsPanelRespond());
        this.resetAll.addActionListener(new optionsPanelRespond());
        this.optPanel1.add(this.optAlarm);
        this.optPanel1.add(new JLabel(".wav"));
        this.optPanel2.add(new JLabel("Hr:"));
        this.optPanel2.add(this.optSnzeHr);
        this.optPanel2.add(new JLabel("Min:"));
        this.optPanel2.add(this.optSnzeMin);
        this.optPanel2.add(new JLabel("Sec:"));
        this.optPanel2.add(this.optSnzeSec);
        this.optPanel3.add(this.optTimetype);
        this.optPanel4.add(this.optCancel);
        this.optPanel4.add(this.optOK);
        this.resetAlarm.addActionListener(new optionsResetRespond());
        this.resetSnooze.addActionListener(new optionsResetRespond());
        this.resetType.addActionListener(new optionsResetRespond());
        this.optionsPanel = new JFrame("Default Options");
        this.optionsPanel.setSize(450, 200);
        this.optionsPanel.setDefaultCloseOperation(1);
        GroupLayout gl = new GroupLayout(this.optionsPanel.getContentPane());
        this.optionsPanel.getContentPane().setLayout(gl);
        GroupLayout.SequentialGroup hGroup = gl.createSequentialGroup();
        hGroup.addGroup(gl.createParallelGroup().addComponent(this.optAlarmLabel).addComponent(this.optSnoozeLabel).addComponent(this.optTypeLabel).addGap(1));
        hGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.resetAlarm).addComponent(this.resetSnooze).addComponent(this.resetType).addComponent(this.resetAll));
        hGroup.addGroup(gl.createParallelGroup().addComponent(this.optPanel1).addComponent(this.optPanel2).addComponent(this.optPanel3).addComponent(this.optPanel4));
        gl.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = gl.createSequentialGroup();
        vGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optAlarmLabel).addComponent(this.resetAlarm).addComponent(this.optPanel1));
        vGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optSnoozeLabel).addComponent(this.resetSnooze).addComponent(this.optPanel2));
        vGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optTypeLabel).addComponent(this.resetType).addComponent(this.optPanel3));
        vGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addGap(1).addComponent(this.resetAll).addComponent(this.optPanel4));
        gl.setVerticalGroup(vGroup);
        this.loadData();
        this.tWindow.setLayout(new BorderLayout());
        this.tWindow.setJMenuBar(this.menu);
        this.tWindow.getContentPane().add((Component)this.soundPanel, "North");
        this.tWindow.getContentPane().add((Component)this.timerPanel, "Center");
        this.tWindow.setSize(800, 700);
        this.tWindow.setDefaultCloseOperation(3);
        this.tWindow.setVisible(true);
    }

    private void sortMenus() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.fileBlank = new JMenuItem("New", 78);
        this.fileBlank.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.fileBlank.addActionListener(new fileListener());
        this.fileLoad = new JMenu("Load");
        this.fileLoad.setMnemonic(76);
        JMenuItem fileLoad1 = new JMenuItem("Time Keeper 1");
        fileLoad1.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        fileLoad1.addActionListener(new loadListener(1));
        JMenuItem fileLoad2 = new JMenuItem("Time Keeper 2");
        fileLoad2.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        fileLoad2.addActionListener(new loadListener(2));
        JMenuItem fileLoad3 = new JMenuItem("Time Keeper 3");
        fileLoad3.setAccelerator(KeyStroke.getKeyStroke(51, 2));
        fileLoad3.addActionListener(new loadListener(3));
        JMenuItem fileLoad4 = new JMenuItem("Time Keeper 4");
        fileLoad4.setAccelerator(KeyStroke.getKeyStroke(52, 2));
        fileLoad4.addActionListener(new loadListener(4));
        JMenuItem fileLoad5 = new JMenuItem("Time Keeper 5");
        fileLoad5.setAccelerator(KeyStroke.getKeyStroke(53, 2));
        fileLoad5.addActionListener(new loadListener(5));
        JMenuItem fileLoad6 = new JMenuItem("Time Keeper 6");
        fileLoad6.setAccelerator(KeyStroke.getKeyStroke(54, 2));
        fileLoad6.addActionListener(new loadListener(6));
        JMenuItem fileLoad7 = new JMenuItem("Time Keeper 7");
        fileLoad7.setAccelerator(KeyStroke.getKeyStroke(55, 2));
        fileLoad7.addActionListener(new loadListener(7));
        JMenuItem fileLoad8 = new JMenuItem("Time Keeper 8");
        fileLoad8.setAccelerator(KeyStroke.getKeyStroke(56, 2));
        fileLoad8.addActionListener(new loadListener(8));
        JMenuItem fileLoad9 = new JMenuItem("Time Keeper 9");
        fileLoad9.setAccelerator(KeyStroke.getKeyStroke(57, 2));
        fileLoad9.addActionListener(new loadListener(9));
        this.fileLoad.add(fileLoad1);
        this.fileLoad.add(fileLoad2);
        this.fileLoad.add(fileLoad3);
        this.fileLoad.add(fileLoad4);
        this.fileLoad.add(fileLoad5);
        this.fileLoad.add(fileLoad6);
        this.fileLoad.add(fileLoad7);
        this.fileLoad.add(fileLoad8);
        this.fileLoad.add(fileLoad9);
        this.fileSave = new JMenu("Save");
        this.fileSave.setMnemonic(83);
        JMenuItem fileSave1 = new JMenuItem("Time Keeper 1");
        fileSave1.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        fileSave1.addActionListener(new saveListener(1));
        JMenuItem fileSave2 = new JMenuItem("Time Keeper 2");
        fileSave2.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        fileSave2.addActionListener(new saveListener(2));
        JMenuItem fileSave3 = new JMenuItem("Time Keeper 3");
        fileSave3.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        fileSave3.addActionListener(new saveListener(3));
        JMenuItem fileSave4 = new JMenuItem("Time Keeper 4");
        fileSave4.setAccelerator(KeyStroke.getKeyStroke(52, 8));
        fileSave4.addActionListener(new saveListener(4));
        JMenuItem fileSave5 = new JMenuItem("Time Keeper 5");
        fileSave5.setAccelerator(KeyStroke.getKeyStroke(53, 8));
        fileSave5.addActionListener(new saveListener(5));
        JMenuItem fileSave6 = new JMenuItem("Time Keeper 6");
        fileSave6.setAccelerator(KeyStroke.getKeyStroke(54, 8));
        fileSave6.addActionListener(new saveListener(6));
        JMenuItem fileSave7 = new JMenuItem("Time Keeper 7");
        fileSave7.setAccelerator(KeyStroke.getKeyStroke(55, 8));
        fileSave7.addActionListener(new saveListener(7));
        JMenuItem fileSave8 = new JMenuItem("Time Keeper 8");
        fileSave8.setAccelerator(KeyStroke.getKeyStroke(56, 8));
        fileSave8.addActionListener(new saveListener(8));
        JMenuItem fileSave9 = new JMenuItem("Time Keeper 9");
        fileSave9.setAccelerator(KeyStroke.getKeyStroke(57, 8));
        fileSave9.addActionListener(new saveListener(9));
        this.fileSave.add(fileSave1);
        this.fileSave.add(fileSave2);
        this.fileSave.add(fileSave3);
        this.fileSave.add(fileSave4);
        this.fileSave.add(fileSave5);
        this.fileSave.add(fileSave6);
        this.fileSave.add(fileSave7);
        this.fileSave.add(fileSave8);
        this.fileSave.add(fileSave9);
        this.fileExit = new JMenuItem("Exit", 69);
        this.fileExit.addActionListener(new fileListener());
        this.fileMenu.add(this.fileBlank);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.fileLoad);
        this.fileMenu.add(this.fileSave);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.fileExit);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(84);
        this.toolsStop = new JMenuItem("Stop Alarm", 83);
        this.toolsStop.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.toolsStop.addActionListener(new stopAlarm());
        this.toolsMulti = new JMenuItem("Multi S/S", 77);
        this.toolsMulti.setAccelerator(KeyStroke.getKeyStroke(8, 0));
        this.toolsMulti.addActionListener(new multiListener());
        this.toolsStartAll = new JMenuItem("Start All", 65);
        this.toolsStartAll.addActionListener(new startStopListener());
        this.toolsStartAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.toolsStopAll = new JMenuItem("Stop All", 90);
        this.toolsStopAll.addActionListener(new startStopListener());
        this.toolsStopAll.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.toolsOptions = new JMenuItem("Options", 79);
        this.toolsOptions.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.toolsOptions.addActionListener(new optionsListener());
        this.toolsMenu.add(this.toolsStop);
        this.toolsMenu.add(this.toolsMulti);
        this.toolsMenu.add(this.toolsStartAll);
        this.toolsMenu.add(this.toolsStopAll);
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(this.toolsOptions);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        this.helpUpdate = new JMenuItem("Check for Updates", 85);
        this.helpUpdate.addActionListener(new helpListener());
        this.helpAbout = new JMenuItem("About", 65);
        this.helpAbout.setMnemonic(65);
        this.helpAbout.addActionListener(new helpListener());
        this.helpMenu.add(this.helpUpdate);
        this.helpMenu.add(this.helpAbout);
    }

    public int getSnoozeHour() {
        return this.snoozehour;
    }

    public int getSnoozeMin() {
        return this.snoozemin;
    }

    public int getSnoozeSec() {
        return this.snoozesec;
    }

    public int getTimeType() {
        return this.timetype;
    }

    public void refresh() {
        this.tWindow.repaint();
    }

    private void reload() {
        this.refresh();
        this.tWindow.setVisible(true);
    }

    public void alert(timer t) {
        this.alert(t, this.alert);
    }

    public void alert(timer t, String s) {
        try {
            this.codeBase = new URL("file:" + System.getProperty("user.dir") + "/" + s + ".wav");
            this.clip = Applet.newAudioClip(this.codeBase);
        }
        catch (MalformedURLException e) {
            System.err.println(e.getMessage());
        }
        File f = new File(this.codeBase.getFile());
        if (f.exists()) {
            try {
                this.clip.play();
                if (t.getFeedback() == "No Sound!") {
                    t.feedbackUser(0);
                }
            }
            catch (NullPointerException e) {
                t.feedbackUser(2);
            }
        } else {
            t.feedbackUser(2);
        }
    }

    public void runInc() {
        if (this.running == 0) {
            this.toolsOptions.setEnabled(false);
        }
        ++this.running;
    }

    public void runDec() {
        --this.running;
        if (this.running == 0) {
            this.toolsOptions.setEnabled(true);
        }
    }

    private void setTimerPanel() {
        this.timerPanel.add(this.t1);
        this.timerPanel.add(this.t2);
        this.timerPanel.add(this.t3);
        this.timerPanel.add(this.t4);
        this.timerPanel.add(this.t5);
        this.timerPanel.add(this.t6);
        this.timerPanel.add(this.t7);
        this.timerPanel.add(this.t8);
        this.timerPanel.add(this.t9);
    }

    private void newtimers() {
        int x = JOptionPane.showConfirmDialog(null, "This will reset all time keepers.\nAre you sure you want to proceed?", "Warning!", 0);
        if (x == 0) {
            this.t1.newtimer(1);
            this.t2.newtimer(2);
            this.t3.newtimer(3);
            this.t4.newtimer(4);
            this.t5.newtimer(5);
            this.t6.newtimer(6);
            this.t7.newtimer(7);
            this.t8.newtimer(8);
            this.t9.newtimer(9);
            this.reload();
        }
    }

    private void loadtimers(int t) {
        this.setupFc(0, t);
        if (this.fc.showOpenDialog(this.tWindow) == 0) {
            File file = this.fc.getSelectedFile();
            if (!file.isFile() && !file.getName().endsWith(".jtk")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".jtk");
            }
            if (file.isFile() && file.getName().endsWith(".jtk")) {
                try {
                    XMLDecoder in = new XMLDecoder(new BufferedInputStream(new FileInputStream(file)));
                    try {
                        if (t == 1) {
                            this.t1.loadTimer(in);
                        } else if (t == 2) {
                            this.t2.loadTimer(in);
                        } else if (t == 3) {
                            this.t3.loadTimer(in);
                        } else if (t == 4) {
                            this.t4.loadTimer(in);
                        } else if (t == 5) {
                            this.t5.loadTimer(in);
                        } else if (t == 6) {
                            this.t6.loadTimer(in);
                        } else if (t == 7) {
                            this.t7.loadTimer(in);
                        } else if (t == 8) {
                            this.t8.loadTimer(in);
                        } else if (t == 9) {
                            this.t9.loadTimer(in);
                        }
                        in.close();
                        this.reload();
                        JOptionPane.showMessageDialog(null, "The program has loaded " + file.getName() + " successfully", "Load Successful!", 1);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new IOException();
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "The program failed to load the file. Please check you have provided an accurate file name.", "Load Failed!", 2);
                    System.out.println(e);
                }
                catch (NoSuchElementException n) {
                    JOptionPane.showMessageDialog(null, "The program failed to load the file. This file is an old version of .jtk and is no longer supported.", "Load Failed!", 2);
                    System.out.println(n);
                }
            } else {
                JOptionPane.showMessageDialog(null, "The file you have chosen is not a Jarada's Time Keeper. Please try again.", "File Incorrect!", 0);
            }
        }
    }

    private void savetimers(int t) {
        this.t1.prepareSerialise();
        this.t2.prepareSerialise();
        this.t3.prepareSerialise();
        this.t4.prepareSerialise();
        this.t5.prepareSerialise();
        this.t6.prepareSerialise();
        this.t7.prepareSerialise();
        this.t8.prepareSerialise();
        this.t9.prepareSerialise();
        this.refresh();
        this.setupFc(1, t);
        if (this.fc.showSaveDialog(this.tWindow) == 0) {
            File file = this.fc.getSelectedFile();
            if (!file.getName().endsWith(".jtk")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".jtk");
            }
            try {
                boolean proceed = true;
                if (file.exists()) {
                    int option = JOptionPane.showConfirmDialog(this.tWindow, "File exists. Overwrite?");
                    if (option == 2) {
                        proceed = false;
                    } else if (option == 1) {
                        proceed = false;
                        this.savetimers(t);
                    }
                }
                if (proceed) {
                    FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
                    XMLEncoder oos = new XMLEncoder(fos);
                    if (t == 1) {
                        this.t1.saveTimer(oos);
                    } else if (t == 2) {
                        this.t2.saveTimer(oos);
                    } else if (t == 3) {
                        this.t3.saveTimer(oos);
                    } else if (t == 4) {
                        this.t4.saveTimer(oos);
                    } else if (t == 5) {
                        this.t5.saveTimer(oos);
                    } else if (t == 6) {
                        this.t6.saveTimer(oos);
                    } else if (t == 7) {
                        this.t7.saveTimer(oos);
                    } else if (t == 8) {
                        this.t8.saveTimer(oos);
                    } else if (t == 9) {
                        this.t9.saveTimer(oos);
                    }
                    oos.close();
                    JOptionPane.showMessageDialog(null, "The program has saved " + file.getName() + " successfully", "Save Successful!", 1);
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "The program failed to save the file. Please try again.", "Save Failed!", 2);
            }
        }
    }

    private void loadData() {
        File f = new File("options.dat");
        if (f.exists()) {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(f));
                this.alert = (String)in.readObject();
                this.snoozehour = (Integer)in.readObject();
                this.snoozemin = (Integer)in.readObject();
                this.snoozesec = (Integer)in.readObject();
                this.timetype = (Integer)in.readObject();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "The program failed to load the options data. The Options file may be corrupted.", "Load Failed!", 2);
            }
        }
    }

    private void saveData() {
        File f = new File("options.dat");
        try {
            FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.alert);
            oos.writeObject(this.snoozehour);
            oos.writeObject(this.snoozemin);
            oos.writeObject(this.snoozesec);
            oos.writeObject(this.timetype);
            oos.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "The program failed to save options changes! Please try again.", "Save Failed!", 2);
        }
    }

    private void setupFc(int type, int t) {
        String title = "";
        if (type == 0) {
            title = "Load into ";
        } else if (type == 1) {
            title = "Save ";
        }
        if (t == 1) {
            title = String.valueOf(title) + this.t1.getMessage();
        } else if (t == 2) {
            title = String.valueOf(title) + this.t2.getMessage();
        } else if (t == 3) {
            title = String.valueOf(title) + this.t3.getMessage();
        } else if (t == 4) {
            title = String.valueOf(title) + this.t4.getMessage();
        } else if (t == 5) {
            title = String.valueOf(title) + this.t5.getMessage();
        } else if (t == 6) {
            title = String.valueOf(title) + this.t6.getMessage();
        } else if (t == 7) {
            title = String.valueOf(title) + this.t7.getMessage();
        } else if (t == 8) {
            title = String.valueOf(title) + this.t8.getMessage();
        } else if (t == 9) {
            title = String.valueOf(title) + this.t9.getMessage();
        }
        this.fc.setDialogTitle(title);
    }

    class stopAlarm
    implements ActionListener {
        stopAlarm() {
        }

        public void actionPerformed(ActionEvent e) {
            timerWindow.this.clip.stop();
        }
    }

    class multiListener
    implements ActionListener {
        multiListener() {
        }

        public void actionPerformed(ActionEvent e) {
            timerWindow.this.t1.multi();
            timerWindow.this.t2.multi();
            timerWindow.this.t3.multi();
            timerWindow.this.t4.multi();
            timerWindow.this.t5.multi();
            timerWindow.this.t6.multi();
            timerWindow.this.t7.multi();
            timerWindow.this.t8.multi();
            timerWindow.this.t9.multi();
        }
    }

    class startStopListener
    implements ActionListener {
        startStopListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == timerWindow.this.toolsStartAll) {
                timerWindow.this.t1.allStart();
                timerWindow.this.t2.allStart();
                timerWindow.this.t3.allStart();
                timerWindow.this.t4.allStart();
                timerWindow.this.t5.allStart();
                timerWindow.this.t6.allStart();
                timerWindow.this.t7.allStart();
                timerWindow.this.t8.allStart();
                timerWindow.this.t9.allStart();
            } else if (e.getSource() == timerWindow.this.toolsStopAll) {
                timerWindow.this.t1.allStop();
                timerWindow.this.t2.allStop();
                timerWindow.this.t3.allStop();
                timerWindow.this.t4.allStop();
                timerWindow.this.t5.allStop();
                timerWindow.this.t6.allStop();
                timerWindow.this.t7.allStop();
                timerWindow.this.t8.allStop();
                timerWindow.this.t9.allStop();
            }
        }
    }

    class eggListener
    implements ActionListener {
        eggListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(null, "If you see something missing from this program,\n why not tell me? I might well add your idea!\n See the Readme for more information.", "Where's That Feature?", 1);
        }
    }

    class fileListener
    implements ActionListener {
        fileListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == timerWindow.this.fileBlank) {
                timerWindow.this.newtimers();
            } else if (e.getSource() == timerWindow.this.fileExit) {
                System.exit(0);
            }
        }
    }

    class loadListener
    implements ActionListener {
        int x;

        public loadListener(int z) {
            this.x = z;
        }

        public void actionPerformed(ActionEvent e) {
            timerWindow.this.loadtimers(this.x);
        }
    }

    class saveListener
    implements ActionListener {
        int x;

        public saveListener(int z) {
            this.x = z;
        }

        public void actionPerformed(ActionEvent e) {
            timerWindow.this.savetimers(this.x);
        }
    }

    class optionsListener
    implements ActionListener {
        optionsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            timerWindow.this.optAlarm.setText(timerWindow.this.alert);
            timerWindow.this.optSnzeHr.setText(Integer.toString(timerWindow.this.snoozehour));
            timerWindow.this.optSnzeMin.setText(Integer.toString(timerWindow.this.snoozemin));
            timerWindow.this.optSnzeSec.setText(Integer.toString(timerWindow.this.snoozesec));
            timerWindow.this.optTimetype.setSelectedIndex(timerWindow.this.timetype);
            timerWindow.this.optionsPanel.setVisible(true);
        }
    }

    class helpListener
    implements ActionListener {
        helpListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == timerWindow.this.helpAbout) {
                JOptionPane.showMessageDialog(null, "Created by Jarada Productions.\n24/07/07.\nVersion 2.2.0.", "About Jarada's Time Keepers V2.0", 1);
            } else if (e.getSource() == timerWindow.this.helpUpdate) {
                try {
                    boolean updateNeeded = false;
                    URL u = new URL("http://jarada.co.uk/timerupdate.dat");
                    URLConnection dat = u.openConnection();
                    ObjectInputStream in = new ObjectInputStream(dat.getInputStream());
                    int ma = (Integer)in.readObject();
                    int mi = (Integer)in.readObject();
                    int bf = (Integer)in.readObject();
                    if (ma > 2) {
                        updateNeeded = true;
                    } else if (ma == 2) {
                        if (mi > 2) {
                            updateNeeded = true;
                        } else if (mi == 2 && bf > 0) {
                            updateNeeded = true;
                        }
                    }
                    if (updateNeeded) {
                        JOptionPane.showMessageDialog(null, "Update Available! \nVersion " + ma + "." + mi + "." + bf + " is available to download.", "Update Jarada's Time Keepers", 2);
                    } else {
                        JOptionPane.showMessageDialog(null, "Program is up to date.", "Update Jarada's Time Keepers", 1);
                    }
                }
                catch (Exception err) {
                    JOptionPane.showMessageDialog(null, "Program failed to connect to server.", "Update Jarada's Time Keepers", 0);
                    System.out.println(err);
                }
            }
        }
    }

    class optionsPanelRespond
    implements ActionListener {
        optionsPanelRespond() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == timerWindow.this.optOK) {
                timerWindow.this.alert = timerWindow.this.optAlarm.getText();
                try {
                    timerWindow.this.snoozehour = Integer.parseInt(timerWindow.this.optSnzeHr.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    timerWindow.this.snoozemin = Integer.parseInt(timerWindow.this.optSnzeMin.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    timerWindow.this.snoozesec = Integer.parseInt(timerWindow.this.optSnzeSec.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                timerWindow.this.timetype = timerWindow.this.optTimetype.getSelectedIndex();
                timerWindow.this.optionsPanel.setVisible(false);
                timerWindow.this.saveData();
            } else if (e.getSource() == timerWindow.this.optCancel) {
                timerWindow.this.optionsPanel.setVisible(false);
            } else if (e.getSource() == timerWindow.this.resetAll) {
                timerWindow.this.optAlarm.setText("alert");
                timerWindow.this.optSnzeHr.setText(Integer.toString(0));
                timerWindow.this.optSnzeMin.setText(Integer.toString(5));
                timerWindow.this.optSnzeSec.setText(Integer.toString(0));
                timerWindow.this.optTimetype.setSelectedIndex(0);
            }
        }
    }

    class optionsResetRespond
    implements ActionListener {
        optionsResetRespond() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == timerWindow.this.resetAlarm) {
                timerWindow.this.optAlarm.setText("alert");
            } else if (e.getSource() == timerWindow.this.resetSnooze) {
                timerWindow.this.optSnzeHr.setText(Integer.toString(0));
                timerWindow.this.optSnzeMin.setText(Integer.toString(5));
                timerWindow.this.optSnzeSec.setText(Integer.toString(0));
            } else if (e.getSource() == timerWindow.this.resetType) {
                timerWindow.this.optTimetype.setSelectedIndex(0);
            }
        }
    }
}

